using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DoorScript : MonoBehaviour
{
    bool forward = true;

    public float radius = 3f;
    public Transform interactionTransform;
    MouseLook mouseLook;
    Animator animator;

    private void Start()
    {
        mouseLook = GameObject.Find("SoupEmpty").GetComponent<MouseLook>();
        animator = gameObject.GetComponent<Animator>();
    }
    public void Toggle()
    {
        if (forward)
        {
            animator.SetBool("ToggledFoward",true);
            animator.Play("DoorAnimation");
            animator.SetBool("ToggledFoward", false);
        }
        else
        {
            animator.SetBool("ToggledBackward", true);
            animator.Play("DoorAnimationBack");
            animator.SetBool("ToggledBackward", false);

        }
        forward = !forward;
    }
    void OnDrawGizmosSelected()
    {
        if (interactionTransform == null)
        {
            interactionTransform = transform;
        }
        Gizmos.color = Color.yellow;
        Gizmos.DrawWireSphere(new Vector3(transform.position.x - 3, transform.position.y-4, transform.position.z), radius);
    }
    private void Update()
    {
        if (mouseLook.focusName == gameObject.name)
        {
            Toggle();
            mouseLook.focusName = "";
        }
    }
}
